#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_xor_IO16AX_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg0=AX;
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
AX=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit16u disp;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD16_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit32u disp;
Bit16u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD32_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD32_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsD32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm161_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm161_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm161_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm321_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm321_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm321_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm322D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm322D32_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16dsrm322D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D16_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D8_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r1rm161D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D16_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D8_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16r2rm162_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D32_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D32_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D8_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321D8_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm321_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D32_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D8_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323D8_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16rarm323_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regm_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regm_I16imm8s(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regm_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr2_I16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_16BIT_REG((last2&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_16BIT_REG((last&0x38)/8);
read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO16regr_I16regm(int seg,Bit8u* imm)
{
Bit16u arg0_save;
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x38)/8);
arg1=BX_READ_16BIT_REG((last&0x7));

arg0_save=arg0;
arg0^=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_16(arg0_save,arg1,arg0,BX_INSTR_XOR16);
}

void BX_CPU_C::EXEC_xor_IO32EAX_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg0=EAX;
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
EAX=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit16u disp;
Bit32u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD16_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit32u disp;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD32_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD32_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsD32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm161_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm161_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm161_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm321_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm321_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm321_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm322D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm322D32_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32dsrm322D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D16_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D8_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r1rm161D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D16_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D8_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32r2rm162_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D32_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D32_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D8_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321D8_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm321_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D32_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D8_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323D8_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32rarm323_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regm_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regm_I32imm8s(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=(Bit8s)immdat;

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regm_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32dsrm322D32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm321(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm323(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm323D32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr2_I32rarm323D8(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_READ_32BIT_REG((last2&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32dsrm161(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32dsrm321(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32r1rm161D16(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32r1rm161D8(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32r2rm162(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32r2rm162D16(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32r2rm162D8(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_READ_32BIT_REG((last&0x38)/8);
read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO32regr_I32regm(int seg,Bit8u* imm)
{
Bit32u arg0_save;
Bit32u arg0;
Bit32u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x38)/8);
arg1=BX_READ_32BIT_REG((last&0x7));

arg0_save=arg0;
arg0^=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

SET_FLAGS_OSZAPC_32(arg0_save,arg1,arg0,BX_INSTR_XOR32);
}

void BX_CPU_C::EXEC_xor_IO8AL_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg0=AL;
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
AL=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD32_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD32_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsD32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm161_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm161_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm161_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm321_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm321_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm322D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm322D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8dsrm322D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r1rm161D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8r2rm162_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D32_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D32_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D8_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321D8_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm321_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D8_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323D8_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8rarm323_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghm_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghm_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8dsrm322D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm321(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm323(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm323D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr2_I8rarm323D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8dsrm161(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8dsrm321(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8r1rm161D16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8r1rm161D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8r2rm162(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8r2rm162D16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8r2rm162D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8reghm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reghr_I8reglm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=immdat;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglm_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglm_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8dsrm322D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm321(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm323(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm323D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr2_I8rarm323D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8dsrm161(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8dsrm321(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8r1rm161D16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8r1rm161D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8r2rm162(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8r2rm162D16(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8r2rm162D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8reghm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}

void BX_CPU_C::EXEC_xor_IO8reglr_I8reglm(int seg,Bit8u* imm)
{
Bit8u arg0_save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0_save=arg0;
arg0^=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

SET_FLAGS_OSZAPC_8(arg0_save,arg1,arg0,BX_INSTR_XOR8);
}
